package gov.va.med.mhv.rxrefill.web.controller;

import gov.va.med.mhv.rxrefill.dto.MedicationAndSupplimentCriteria;
import gov.va.med.mhv.rxrefill.dto.MyCompleteMedicationDTO;
import gov.va.med.mhv.rxrefill.service.MyCompleteMedicationsService;
import gov.va.med.mhv.rxrefill.web.util.RxMessagesUtil;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

import javax.annotation.Resource;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.event.data.SortEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.beans.factory.annotation.Value;

import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;

@ManagedBean
@Component
@Scope("session")
public class MyCompleteMedicationsController implements Serializable {
	
	private static final long serialVersionUID = -1947472689045056321L;

	private static Logger log = LogManager.getLogger(MyCompleteMedicationsController.class);
	private DataTable medsTable;
	private List<MyCompleteMedicationDTO> prescriptions = new ArrayList<MyCompleteMedicationDTO>(0);
	private String firstName;
	private String lastName;
	private String userName;
	private MedicationAndSupplimentCriteria searchCriteria= new MedicationAndSupplimentCriteria();
	private MyCompleteMedicationDTO selectedPrescription = new MyCompleteMedicationDTO();
	private String now;
	private static final String SEARCH_CRITERIA_ERROR="You must select at least one Category criterion to filter the results of My Complete Medications List.";
	private static final String ERR_PRCS_RQST = "Error Processing request";
	
	protected ValueExpression sortColumn;
	protected String sortBy;
	protected Long userprofileId;
	protected int rowsPerPage;
	private static final int WARN_ON_REPEAT_COUNT = 3;
	// session scoped - concurrenct access monitor object.
	protected final AtomicInteger monitor = new AtomicInteger(0);
	protected Long lastRefreshTime = 0L;
	
	@Autowired
	private RxMessagesUtil rxMessagesUtil;
	
	@Value("${rxRefreshThreshold}")
	private Long rxRefreshThreshold;
	
	
	@Resource(name = "myCompleteMedicationsServiceProxy")
	private MyCompleteMedicationsService myCompleteMedicationsService;

		
	
	public void init(ComponentSystemEvent event) {
		medsTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("medicationsSummaryForm:medicationList");
		findUser();
		userprofileId = getUserProfileId();
		if(!FacesContext.getCurrentInstance().isPostback()){
			now = getUpdatedTime();
			if (userprofileId != null) {
				monitor.incrementAndGet();
				
				// Synchronize the Prescription Refresh operation
				synchronized(monitor) {
					try {
						if(monitor.get() >  WARN_ON_REPEAT_COUNT) {
							System.out.println("AtomicInteger value in MyCompleteMedicationsController is incremented and warn on repeat count value");
							FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, 
									rxMessagesUtil.getWarnMultipleRefreshes(), rxMessagesUtil.getWarnMultipleRefreshes()));
						}
						
						if((System.currentTimeMillis() - this.lastRefreshTime) >  this.rxRefreshThreshold) {
							System.out.println("lastRefreshTime in MyCompleteMedicationsController: " + lastRefreshTime + " ;rxRefreshThreshold value: " + this.rxRefreshThreshold);								
						    this.lastRefreshTime = System.currentTimeMillis();
							setDeaultSearchCriteria();
							prescriptions = findPrescriptions(searchCriteria);
						}
					} finally {
						monitor.decrementAndGet();
					}
				}
				

			}
			setRowsPerPage(10);
		}else {
			if (sortColumn != null && sortBy != null){
				medsTable.setValueExpression("sortBy", sortColumn);
				medsTable.setSortOrder(sortBy);
			} 
		}
	}
	
	public void onSort(SortEvent event){
		sortColumn=event.getSortColumn().getValueExpression("sortBy");
		sortBy=event.isAscending()?"ascending":"descending";
	}
	
	private void setDeaultSearchCriteria() {
		searchCriteria.setHerbsSuppliments(true);
		searchCriteria.setOtc(true);
		searchCriteria.setOther(true);
		searchCriteria.setRxMedication(true);
		searchCriteria.setSource("BOTH");
		searchCriteria.setStatus("BOTH");
		searchCriteria.setUserName(userName);
		searchCriteria.setUserProfileId(userprofileId);
	}

	private List<MyCompleteMedicationDTO> findPrescriptions(MedicationAndSupplimentCriteria searchCriteria ) {
		List<MyCompleteMedicationDTO> prescriptions = null;
		try {
			prescriptions = getMyCompleteMedicationsService().getCompleteMedicationList(searchCriteria);
			if(prescriptions != null){
				
				Collections.sort(prescriptions, new Comparator<MyCompleteMedicationDTO>() {

					@Override
					public int compare(MyCompleteMedicationDTO pres1,
							MyCompleteMedicationDTO pres2) {
						 int statusComp = 0;
						 statusComp = pres1.getStatus().compareTo(pres2.getStatus());
						 if (statusComp != 0) { 
							  return statusComp;
							 }
						 
					return -1 *  pres1.getIssueDateTime().compareTo(pres2.getIssueDateTime());
					     
						
					}});
				

					
			}
		} catch (Exception e) {
			log.error("Error in fetching prescription histories", e);
			FacesContext.getCurrentInstance().addMessage(null, 
					new FacesMessage(FacesMessage.SEVERITY_ERROR, ERR_PRCS_RQST, ERR_PRCS_RQST));
		}
		return prescriptions;
	}
	
	public String showDetail(MyCompleteMedicationDTO prescription){
		selectedPrescription = prescription;
		String outcome=null;
		if(selectedPrescription.getSource().equals("SELF")){
			outcome="myCompleteSelfmedicationDetail";
		}else{
			outcome="myCompleteVAMedicationDetail";
		}
		return outcome;
	}
	
	public String searchCompleteMedications(){
		if (userprofileId != null) {
			if(!searchCriteria.getHerbsSuppliments() && 
			   !searchCriteria.getOtc() &&
			   !searchCriteria.getOther() &&
			   !searchCriteria.getRxMedication()){
				FacesContext.getCurrentInstance().addMessage(null, 
						new FacesMessage(FacesMessage.SEVERITY_ERROR, SEARCH_CRITERIA_ERROR, SEARCH_CRITERIA_ERROR));
			}else{
			   prescriptions = findPrescriptions(searchCriteria);
			}
		}
		return "myCompleteMedicationsSummary";
	}
	
	public String printerFriendlySummary(){
		medsTable = (DataTable) FacesContext.getCurrentInstance().getViewRoot().findComponent("medicationsSummaryForm:medicationList");
		return "myCompleteMedicationsSummaryPrint";
	}
	
	public void findUser() {
		PortletRequest   request = (PortletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
		User user=null;
        try{
        	user =PortalUtil.getUser(request);
        }catch(Exception e){
        	
        }
		if(user != null){
			setFirstName(user.getFirstName());
			setLastName(user.getLastName());
			setUserName(user.getScreenName());
		}
	}
	
	protected Long getUserProfileId() {
		Long userprofileId = null;
		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		Object profileId = session.getAttribute("LIFERAY_SHARED_userprofileid",
				PortletSession.APPLICATION_SCOPE);
		if (profileId != null) {
			userprofileId = (Long) profileId;
		}
		return userprofileId;
	}
	
	public String getMhvContext(){
		String context = PropsUtil.get("mhv.context");
		return  context;
    }


	private String getUpdatedTime() {
		String time=null;
		SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy");
		fmt.setTimeZone(TimeZone.getTimeZone("America/New_York"));
		String datePart =fmt.format(new Date());
		fmt=new SimpleDateFormat("HH:mm");
		fmt.setTimeZone(TimeZone.getTimeZone("America/New_York"));
		String timePart=fmt.format(new Date());
		time = datePart + " at "+ timePart;
		return time;
	}


	public String getFirstName() {
		return firstName;
	}


	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}


	public String getLastName() {
		return lastName;
	}


	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public DataTable getMedsTable() {
		return medsTable;
	}

	public void setMedsTable(DataTable medsTable) {
		this.medsTable = medsTable;
	}

	public MyCompleteMedicationsService getMyCompleteMedicationsService() {
		return myCompleteMedicationsService;
	}

	public void setMyCompleteMedicationsService(
			MyCompleteMedicationsService myCompleteMedicationsService) {
		this.myCompleteMedicationsService = myCompleteMedicationsService;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}



	public List<MyCompleteMedicationDTO> getPrescriptions() {
		return prescriptions;
	}



	public void setPrescriptions(List<MyCompleteMedicationDTO> prescriptions) {
		this.prescriptions = prescriptions;
	}



	public MyCompleteMedicationDTO getSelectedPrescription() {
		return selectedPrescription;
	}



	public void setSelectedPrescription(MyCompleteMedicationDTO selectedPrescription) {
		this.selectedPrescription = selectedPrescription;
	}



	public MedicationAndSupplimentCriteria getSearchCriteria() {
		return searchCriteria;
	}



	public void setSearchCriteria(MedicationAndSupplimentCriteria searchCriteria) {
		this.searchCriteria = searchCriteria;
	}



	public String getNow() {
		return now;
	}



	public void setNow(String now) {
		this.now = now;
	}


	public Long getUserprofileId() {
		return userprofileId;
	}


	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}


	public ValueExpression getSortColumn() {
		return sortColumn;
	}


	public void setSortColumn(ValueExpression sortColumn) {
		this.sortColumn = sortColumn;
	}


	public String getSortBy() {
		return sortBy;
	}


	public void setSortBy(String sortBy) {
		this.sortBy = sortBy;
	}


	public int getRowsPerPage() {
		return rowsPerPage;
	}


	public void setRowsPerPage(int rowsPerPage) {
		this.rowsPerPage = rowsPerPage;
	}



}
